//
// Voltage Calibration Patch
// by Oleg Titov
//
// project started 13.11.1998
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <math.h>

char* memmem(char *base, size_t blength, char *pattern, size_t plength);

char *prcfile = "vcal.prc";

char mvc[] = {6, 64};                  // magic string for voltage correction
char mip[] = {99, 116, 105, 111, 110}; // magic string for info panel
int main(int argc, char *argv[]){
   FILE *stream;
   struct stat bufStat;
   unsigned char *buf;
   unsigned char *pos;
   char ascii[7];
   unsigned short iVoltage;
   float fVoltage;

   printf("vcal -- Voltage Calibration Patch, by Oleg Titov, 1998\n");

   if(argc == 3) {
      prcfile = argv[2];
   }

   if(NULL == (stream = fopen(prcfile,"rb+"))) {
      printf("Could not open %s\n", prcfile);
      exit(2);
   }

   if(NULL == fstat(fileno(stream), &bufStat)) {
      printf("%s contains %ld bytes\n", prcfile, bufStat.st_size);
   }
   else {
      printf("Bad file handle\n");
      exit(3);
   }

   buf = malloc((size_t)bufStat.st_size);

   if(buf == NULL) {
      printf("Memory allocation error\n");
      exit(4);
   }

   if(bufStat.st_size != fread(buf, 1, bufStat.st_size, stream)) {
      printf("Error loading file %s into memory\n", prcfile);
      exit(5);
   }

   pos = memmem(buf, bufStat.st_size, mvc, sizeof(mvc));
   if(pos == NULL || pos == buf) {
      printf("Unable to find magic string for voltage correction\n");
      exit(6);
   }
   printf("Magic string for voltage correction is found at: %d\n", pos-buf);
   pos = pos + sizeof(mvc);

   if(argc == 1) {
   printf("Reading VoltageCalibration configuration...\n\n");
   iVoltage = 256 * pos[0] + pos[1];
   if(iVoltage > 0xf000) {
      iVoltage = - iVoltage;
      fVoltage = - iVoltage/78.00;
   }
   else {
      fVoltage = + iVoltage/78.00;
   }

   printf("Voltage correction for %s is: %+.3f volts\n", prcfile, fVoltage);
   }

   if(argc >= 2) {
      fVoltage = atof(argv[1]);
      fVoltage *= 78.0;
      if(fVoltage < 0) {
         iVoltage = - ((short)(-fVoltage + 0.5));
         fVoltage = (- ((short)(-iVoltage))/78.0);
      }
      else {
         iVoltage = (short)(fVoltage + 0.5);
         fVoltage = iVoltage/78.0;
      }

      if(fabs(fVoltage) > 0.4) {
         printf("Voltage correction is too big: %+f\n(should be between -0.400 to +0.400 volts)\n", fVoltage);
         exit(7);
      }
      printf("Voltage correction is rounded to %+.3f\n", fVoltage);
//      if(iVoltage > 0xf000) {
//         iVoltage = -iVoltage;
//         iVoltage = ~iVoltage;
//      }

      pos[0] = iVoltage / 256;
      pos[1] = iVoltage % 256;

      pos = memmem(buf, bufStat.st_size, mip, sizeof(mip));
      if(pos == NULL || pos == buf) {
         printf("Unable to find magic string for info panel\n");
         exit(6);
      }
      printf("Magic string for info panel is found at: %u\n", pos-buf);

      sprintf(ascii,"%+.3f",fVoltage);
      memcpy(pos+7, ascii, 6);

      rewind(stream);
      if(bufStat.st_size != fwrite(buf, 1, bufStat.st_size, stream)) {
         printf("Error patching file %s\n", prcfile);
         exit(8);
      }
      printf("Patching complete.\nHotSync new %s and please:\nDisable the old hack first in HackMaster\n", prcfile);
   }

   free(buf);
   fclose(stream);
   return 0;

}

char* memmem(char *base, size_t blength, char *pattern, size_t plength) {
   size_t i;

   if(blength < plength)
      return NULL;

   i = 0;

   do {
      if(memcmp(base+i, pattern, plength) == 0)
         return (base + i);
      i++;
   }
   while(i < blength - plength);

   return EXIT_SUCCESS;
}
